<?php
require_once('TCPDF/tcpdf.php');

function generarPDF($id_cotizacion) {
    // Conexión a la base de datos
    $dsn = 'pgsql:host=localhost;dbname=campus';
    $user = 'zona';
    $password = 'zona2020';

    $rojo=array(230,51,51);
    $beige=array(244,236,225);

    try {
        $dbh = new PDO($dsn, $user, $password);

        // Obtener datos de la cotización
        $stmt = $dbh->prepare("
            SELECT c.fecha_cotizacion, cl.nombre, cl.dni, cl.domicilio, cl.telefono, cl.contacto, c.total_adeudado, c.total_costo, c.total_abonar_cliente
            FROM cotizaciones c
            JOIN clientes cl ON c.id_cliente = cl.id_cliente
            WHERE c.id_cotizacion = ?
        ");
        $stmt->execute([$id_cotizacion]);
        $cotizacion = $stmt->fetch(PDO::FETCH_ASSOC);

        // Obtener datos de los dominios e infracciones
        $stmt = $dbh->prepare("
            SELECT d.dominio, i.nro_acta, i.fecha_infraccion, i.importe, i.porcentaje_costo_estudio, i.porcentaje_descuento, i.observaciones 
            FROM dominios d
            JOIN infracciones i ON d.id_dominio = i.id_dominio
            WHERE d.id_cotizacion = ? order by d.dominio,i.id_infraccion
        ");
        $stmt->execute([$id_cotizacion]);
        $infracciones = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Crear el PDF
        $pdf = new TCPDF();
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Infracciones LF');
        $pdf->SetTitle('Cotización ' . $id_cotizacion);
        $pdf->SetSubject('Cotización de Infracciones');
        $pdf->SetKeywords('TCPDF, PDF, cotización, infracciones');

        // Agregar la primera página
        $pdf->AddPage();

        // Establecer el logo
        $logo = 'infracciones_logo.jpg';
        $pdf->Image($logo, 15, 12, 40, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);

        // Establecer el estilo del título
        $pdf->SetFont('helvetica', 'B', 16);
        $pdf->SetTextColor(230, 51, 51); // Color rojo del logo
        $pdf->Cell(0, 15, 'Cotización de Infracciones', 0, 1, 'C', 0, '', 0, false, 'T', 'M');
        
        // Línea de separación
        $pdf->SetLineStyle(array('width' => 0.3, 'color' => $rojo));
        $pdf->Line(10, 30, 200, 30);

        // Agregar información del cliente
        $pdf->SetFont('helvetica', '', 12);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->Ln(10);
        $pdf->Cell(0, 10, 'Fecha de Cotización: ' . $cotizacion['fecha_cotizacion'], 0, 1);
        $pdf->Cell(0, 10, 'Cliente: ' . $cotizacion['nombre'], 0, 1);
        if($cotizacion['dni']) $pdf->Cell(0, 10, 'DNI: ' . $cotizacion['dni'], 0, 1);
        if($cotizacion['domicilio']) $pdf->Cell(0, 10, 'Domicilio: ' . $cotizacion['domicilio'], 0, 1);
        if($cotizacion['telefono']) $pdf->Cell(0, 10, 'Teléfono: ' . $cotizacion['telefono'], 0, 1);

        // Espacio antes de la tabla
        $pdf->Ln(10);

        // Agregar la tabla de infracciones
        $pdf->SetFont('helvetica', 'B', 10);
	$pdf->SetLineStyle(array('color' => array(230, 51, 51)));
        $pdf->SetFillColor(244, 236, 225); // Color rojo del logo
        $pdf->SetTextColor(230, 51, 51);
        $pdf->Cell(18, 10, 'Dominio', 1, 0, 'C', 1);
        $pdf->Cell(40, 10, 'Nro de Acta', 1, 0, 'C', 1);
        $pdf->Cell(25, 10, 'Fecha Acta', 1, 0, 'C', 1);
        $pdf->Cell(25, 10, 'Importe', 1, 0, 'C', 1);
        $pdf->Cell(25, 10, 'A Abonar', 1, 0, 'C', 1);
        $pdf->Cell(50, 10, 'Observaciones', 1, 1, 'C', 1);

        $pdf->SetFont('helvetica', '', 8.5);
        $pdf->SetTextColor(0, 0, 0);
        foreach ($infracciones as $infraccion) {
            $pdf->Cell(18, 10, $infraccion['dominio'], 1, 0, 'C');
            $pdf->Cell(40, 10, $infraccion['nro_acta'], 1);
            $pdf->Cell(25, 10, $infraccion['fecha_infraccion'], 1, 0, 'C');
            $pdf->Cell(25, 10, '$' . number_format($infraccion['importe'],2,',','.') , 1, 0, 'R');
	    $aabonar = $infraccion['importe'] - ($infraccion['importe'] * $infraccion['porcentaje_descuento']/100);
            $pdf->Cell(25, 10, '$' . number_format($aabonar,2,',','.') , 1, 0, 'R');
            $pdf->Cell(50, 10, $infraccion['observaciones'], 1);
            $pdf->Ln();
        }

        // Espacio antes de los totales
        $pdf->Ln(10);

        // Agregar los totales
        $pdf->SetFont('helvetica', 'B', 12);
        $pdf->SetTextColor(230, 51, 51); // Color rojo del logo
        $pdf->Cell(0, 10, 'Total Adeudado: $ ' . number_format($cotizacion['total_adeudado'],2,',','.'), 0, 1);
        $pdf->Cell(0, 10, 'Total a Abonar por el Cliente: $ ' . number_format($cotizacion['total_abonar_cliente'],2,',','.'), 0, 1);

	$pdf->Ln(10);

        // Agregar las leyendas
        $pdf->SetFont('helvetica', '', 10);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->MultiCell(0, 10, "* La presente cotización tiene una validez de 7 días de corrido. Pasado ese tiempo se debe volver a consultar.", 0, 'L', 0, 1);
        $pdf->MultiCell(0, 10, "* Si su cotización tiene en observaciones la leyenda PUNTOS ROJOS y la misma no se abona en el día de la misma, se deberá volver a cotizar diariamente, ya que puede sufrir cambios.", 0, 'L', 0, 1);


        // Salida del PDF
        $pdf->Output('cotizacion_' . $id_cotizacion . '.pdf', 'I');

    } catch (PDOException $e) {
        echo 'Error: ' . $e->getMessage();
    }
}

// Obtener el ID de la cotización de la URL
if (isset($_GET['id_cotizacion'])) {
    generarPDF($_GET['id_cotizacion']);
}
?>
